#include "FastCoreset.hpp"

FastCoreset::FastCoreset(std::function<Metric<Point>*() > createMetric, std::function<Norm<Point>*() > createNorm) :
weiszfeld(createMetric),
centerOfGravity(createMetric),
kumar(createMetric, createNorm),
lloyd(createMetric, createNorm),
pkmedian(createMetric),
metric(createMetric()),
k(2),
weiszfeldMedianIterations(15),
kumarMedianIterations(5),
maxLloydClusteringIterations(10),
allSamplesSize(200)
{
}

FastCoreset::~FastCoreset()
{
}

void FastCoreset::setWeiszfeldMedianIterations(int weiszfeldMedianIterations)
{
    this->weiszfeldMedianIterations = weiszfeldMedianIterations;
}

int FastCoreset::getWeiszfeldMedianIterations() const
{
    return weiszfeldMedianIterations;
}

void FastCoreset::setK(int k)
{
    this->k = k;
}

int FastCoreset::getK() const
{
    return k;
}

void FastCoreset::setMaxLloydClusteringIterations(int maxLloydClusteringIterations)
{
    this->maxLloydClusteringIterations = maxLloydClusteringIterations;
}

int FastCoreset::getMaxLloydClusteringIterations() const
{
    return maxLloydClusteringIterations;
}

void FastCoreset::setKumarMedianIterations(int kumarMedianIterations)
{
    this->kumarMedianIterations = kumarMedianIterations;
}

int FastCoreset::getKumarMedianIterations() const
{
    return kumarMedianIterations;
}

void FastCoreset::setAllSamplesSize(int allSamplesSize)
{
    this->allSamplesSize = allSamplesSize;
}

int FastCoreset::getAllSamplesSize() const
{
    return allSamplesSize;
}