#ifndef EUCLIDEANSPACE_H
#define EUCLIDEANSPACE_H

#include <vector>
#include <memory>
#include <cmath>
#include <functional>

#include "Point.hpp"
#include "Norm.hpp"

/**
 * @brief Euclidean space operations for Point objetcs
 */
class EuclideanSpace
{
public:
	EuclideanSpace(std::function<Norm<Point>*()> createNorm);

	template<typename InputIterator>
	std::unique_ptr<std::vector<Point>> orthonormalize(InputIterator begin, InputIterator end);

private:
	Norm<Point>* norm;
};


template<typename InputIterator>
std::unique_ptr<std::vector<Point>> EuclideanSpace::orthonormalize(InputIterator begin, InputIterator end)
{
	std::unique_ptr<std::vector<Point>> basis(new std::vector<Point>());
	auto proj = [](Point const & u, Point const & v) -> Point
	{
		return ((u*v) * (1/(u*u))) * u;
	};

	// Normalize vectors
	int dim = 0;
	while(begin != end)
	{
		Point p(*begin);
		for(int i = 0; i < dim; ++i)
			p = p - proj((*basis)[i], p);
		// Check for linear dependency
		if(norm->length(p) > 0.000001)
		{
			p = (1 / norm->length(p)) * p;
			basis->push_back(p);
			++dim;
		}
		++begin;
	}

	return basis;
}

#endif
