# GNU Make project makefile autogenerated by Premake
ifndef config
  config=debug
endif

ifndef verbose
  SILENT = @
endif

ifndef CC
  CC = gcc
endif

ifndef CXX
  CXX = g++
endif

ifndef AR
  AR = ar
endif

ifeq ($(config),debug)
  OBJDIR     = obj/Debug/LLOYD
  TARGETDIR  = bin
  TARGET     = $(TARGETDIR)/lloyd.exe
  DEFINES   += -DERRORHANDLER
  INCLUDES  += -I../libs
  CPPFLAGS  += -MMD -MP $(DEFINES) $(INCLUDES)
  CFLAGS    += $(CPPFLAGS) $(ARCH) -g -std=c++0x -static-libstdc++ -static-libgcc
  CXXFLAGS  += $(CFLAGS) 
  LDFLAGS   += -static-libstdc++ -static-libgcc
  LIBS      += 
  RESFLAGS  += $(DEFINES) $(INCLUDES) 
  LDDEPS    += 
  LINKCMD    = $(CXX) -o $(TARGET) $(OBJECTS) $(LDFLAGS) $(RESOURCES) $(ARCH) $(LIBS)
  define PREBUILDCMDS
  endef
  define PRELINKCMDS
  endef
  define POSTBUILDCMDS
  endef
endif

ifeq ($(config),release)
  OBJDIR     = obj/Release/LLOYD
  TARGETDIR  = bin
  TARGET     = $(TARGETDIR)/lloyd.exe
  DEFINES   += 
  INCLUDES  += -I../libs
  CPPFLAGS  += -MMD -MP $(DEFINES) $(INCLUDES)
  CFLAGS    += $(CPPFLAGS) $(ARCH) -O2 -std=c++0x -static-libstdc++ -static-libgcc
  CXXFLAGS  += $(CFLAGS) 
  LDFLAGS   += -s -static-libstdc++ -static-libgcc
  LIBS      += 
  RESFLAGS  += $(DEFINES) $(INCLUDES) 
  LDDEPS    += 
  LINKCMD    = $(CXX) -o $(TARGET) $(OBJECTS) $(LDFLAGS) $(RESOURCES) $(ARCH) $(LIBS)
  define PREBUILDCMDS
  endef
  define PRELINKCMDS
  endef
  define POSTBUILDCMDS
  endef
endif

ifeq ($(config),debugkmeans)
  OBJDIR     = obj/DebugKmeans/LLOYD
  TARGETDIR  = bin
  TARGET     = $(TARGETDIR)/lloyd.exe
  DEFINES   += -DERRORHANDLER -DKMEANS
  INCLUDES  += -I../libs
  CPPFLAGS  += -MMD -MP $(DEFINES) $(INCLUDES)
  CFLAGS    += $(CPPFLAGS) $(ARCH) -g -std=c++0x -static-libstdc++ -static-libgcc
  CXXFLAGS  += $(CFLAGS) 
  LDFLAGS   += -static-libstdc++ -static-libgcc
  LIBS      += 
  RESFLAGS  += $(DEFINES) $(INCLUDES) 
  LDDEPS    += 
  LINKCMD    = $(CXX) -o $(TARGET) $(OBJECTS) $(LDFLAGS) $(RESOURCES) $(ARCH) $(LIBS)
  define PREBUILDCMDS
  endef
  define PRELINKCMDS
  endef
  define POSTBUILDCMDS
  endef
endif

ifeq ($(config),releasekmeans)
  OBJDIR     = obj/ReleaseKmeans/LLOYD
  TARGETDIR  = bin
  TARGET     = $(TARGETDIR)/lloyd.exe
  DEFINES   += -DKMEANS
  INCLUDES  += -I../libs
  CPPFLAGS  += -MMD -MP $(DEFINES) $(INCLUDES)
  CFLAGS    += $(CPPFLAGS) $(ARCH) -g -std=c++0x -static-libstdc++ -static-libgcc
  CXXFLAGS  += $(CFLAGS) 
  LDFLAGS   += -static-libstdc++ -static-libgcc
  LIBS      += 
  RESFLAGS  += $(DEFINES) $(INCLUDES) 
  LDDEPS    += 
  LINKCMD    = $(CXX) -o $(TARGET) $(OBJECTS) $(LDFLAGS) $(RESOURCES) $(ARCH) $(LIBS)
  define PREBUILDCMDS
  endef
  define PRELINKCMDS
  endef
  define POSTBUILDCMDS
  endef
endif

OBJECTS := \
	$(OBJDIR)/main_lloyd.o \
	$(OBJDIR)/common.o \
	$(OBJDIR)/AdaptiveSampling.o \
	$(OBJDIR)/CenterOfGravity.o \
	$(OBJDIR)/DatastreamCoreset.o \
	$(OBJDIR)/EuclideanMetric.o \
	$(OBJDIR)/EuclideanNorm.o \
	$(OBJDIR)/EuclideanSpace.o \
	$(OBJDIR)/EuclideanSquaredMetric.o \
	$(OBJDIR)/EuclideanSquaredNorm.o \
	$(OBJDIR)/FastCoreset.o \
	$(OBJDIR)/KMedian.o \
	$(OBJDIR)/KumarMedian.o \
	$(OBJDIR)/LloydMedian.o \
	$(OBJDIR)/LloydProbMedian.o \
	$(OBJDIR)/PKMedian.o \
	$(OBJDIR)/Point.o \
	$(OBJDIR)/ProbabilisticPoint.o \
	$(OBJDIR)/Randomness.o \
	$(OBJDIR)/Sampling.o \
	$(OBJDIR)/WeightedPoint.o \
	$(OBJDIR)/Weiszfeld.o \

RESOURCES := \

SHELLTYPE := msdos
ifeq (,$(ComSpec)$(COMSPEC))
  SHELLTYPE := posix
endif
ifeq (/bin,$(findstring /bin,$(SHELL)))
  SHELLTYPE := posix
endif

.PHONY: clean prebuild prelink

all: $(TARGETDIR) $(OBJDIR) prebuild prelink $(TARGET)
	@:

$(TARGET): $(GCH) $(OBJECTS) $(LDDEPS) $(RESOURCES)
	@echo Linking LLOYD
	$(SILENT) $(LINKCMD)
	$(POSTBUILDCMDS)

$(TARGETDIR):
	@echo Creating $(TARGETDIR)
ifeq (posix,$(SHELLTYPE))
	$(SILENT) mkdir -p $(TARGETDIR)
else
	$(SILENT) mkdir $(subst /,\\,$(TARGETDIR))
endif

$(OBJDIR):
	@echo Creating $(OBJDIR)
ifeq (posix,$(SHELLTYPE))
	$(SILENT) mkdir -p $(OBJDIR)
else
	$(SILENT) mkdir $(subst /,\\,$(OBJDIR))
endif

clean:
	@echo Cleaning LLOYD
ifeq (posix,$(SHELLTYPE))
	$(SILENT) rm -f  $(TARGET)
	$(SILENT) rm -rf $(OBJDIR)
else
	$(SILENT) if exist $(subst /,\\,$(TARGET)) del $(subst /,\\,$(TARGET))
	$(SILENT) if exist $(subst /,\\,$(OBJDIR)) rmdir /s /q $(subst /,\\,$(OBJDIR))
endif

prebuild:
	$(PREBUILDCMDS)

prelink:
	$(PRELINKCMDS)

ifneq (,$(PCH))
$(GCH): $(PCH)
	@echo $(notdir $<)
	-$(SILENT) cp $< $(OBJDIR)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
endif

$(OBJDIR)/main_lloyd.o: main_lloyd.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/common.o: common.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/AdaptiveSampling.o: ../probi-source/AdaptiveSampling.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/CenterOfGravity.o: ../probi-source/CenterOfGravity.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/DatastreamCoreset.o: ../probi-source/DatastreamCoreset.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/EuclideanMetric.o: ../probi-source/EuclideanMetric.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/EuclideanNorm.o: ../probi-source/EuclideanNorm.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/EuclideanSpace.o: ../probi-source/EuclideanSpace.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/EuclideanSquaredMetric.o: ../probi-source/EuclideanSquaredMetric.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/EuclideanSquaredNorm.o: ../probi-source/EuclideanSquaredNorm.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/FastCoreset.o: ../probi-source/FastCoreset.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/KMedian.o: ../probi-source/KMedian.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/KumarMedian.o: ../probi-source/KumarMedian.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/LloydMedian.o: ../probi-source/LloydMedian.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/LloydProbMedian.o: ../probi-source/LloydProbMedian.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/PKMedian.o: ../probi-source/PKMedian.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/Point.o: ../probi-source/Point.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/ProbabilisticPoint.o: ../probi-source/ProbabilisticPoint.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/Randomness.o: ../probi-source/Randomness.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/Sampling.o: ../probi-source/Sampling.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/WeightedPoint.o: ../probi-source/WeightedPoint.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
$(OBJDIR)/Weiszfeld.o: ../probi-source/Weiszfeld.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"

-include $(OBJECTS:%.o=%.d)
